// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Welt.h
//
//	erstellt 29.1.98 Andreas Warnke
//	geändert 6.5.98 von Andreas Warnke
//



#ifndef Welt_h_
#define Welt_h_



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Karte.h"
#include "Objekt.h"
#include "ElementList.h"
#include "AVLTree.h"



// // // // // // // // // // // // // // // //
//
//	Welt:
//

class Welt : public Karte
{
protected:
	//	ObjektListe:
	ElementList ObjektListe;
	AVLTree ObjektBaum;
	
	//	Feld von ObjektListen:
	ElementList* ObjektFeld;
	
public:
	//	Konstruktor:
	Welt ( unsigned int MapSize = 10 );
	
	//	Destruktor:
	virtual ~Welt ();
	
	//	Insert:
	virtual bool Insert ( Objekt * inObjekt );
	
	//	Delete:
	virtual Objekt * DeleteID ( unsigned int inID, bool real_deletion );
	virtual void DeleteAtPos ( int inX, int inY );
	
	//	FindObject
	Objekt * FindObject ( unsigned int inID );
	
	//	CountObjects
	unsigned int CountObjects ( int inX, int inY );
	
	//	GetSpieler: liefert 0 falls keine Objekte da.
	unsigned int GetSpielerID ( int inX, int inY );
	
	//	GetObjects
	void GetObjects (
		int inX,
		int inY,
		unsigned int & outTyp,
		unsigned int & outSpieler,
		unsigned int & outAnzahl,
		bool & outAllArmiesBusy );
		
	//	MoveObjectTo:
	//	Voraussetzung: XPos, YPos, MoveToX, MoveToY sind gültig.
	bool MoveObjectTo ( Objekt * inObjekt );
};



#endif



//
//	Ende
//
// // // // // // // // // // // // // // // //